/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: StPGPRefs.h,v 1.16.2.2 2001/04/27 18:28:29 dallen Exp $
____________________________________________________________________________*/

#ifndef Included_StPGPRefs_h	/* [ */
#define Included_StPGPRefs_h



#if PGP_COMPILER_SUN && PGP_COMPILER_SUN_VER == 4
template <class T, void *kInvalidRef>
#elif PGP_COMPILER_GCC || PGP_COMPILER_HPUX || PGP_UNIX_DARWIN
template <class T, int kInvalidRef>
#else
template <class T, T kInvalidRef>
#endif
class StPGPRef {
public:
								StPGPRef()
									{ Set(kInvalidRef); }
								StPGPRef(const T & inRef)
									{ Set(inRef); }
#if PGP_COMPILER_SUN
						~StPGPRef()
#else
	virtual						~StPGPRef()
#endif
									{ Free(); }
	
	PGPBoolean					IsValid() { return (mRef != kInvalidRef); }
	PGPBoolean					IsInvalid() { return (! IsValid()); }
					
	void						Set(T inRef)
									{ mRef = inRef; }
	T							Get()
									{ return mRef; }
	void						Free()
									{ if (mRef != kInvalidRef) Dispose(); mRef = kInvalidRef; }
						
								operator T() { return mRef; }
	T*							operator &() { return &mRef; }
					
	StPGPRef<T, kInvalidRef>&	operator=(const T& rhs) { mRef = rhs; return *this; }
	bool						operator==(const T& rhs) { return mRef == rhs; }
	bool						operator!=(const T& rhs) { return mRef != rhs; }

protected:
	T							mRef;
	
	inline void					Dispose();
};



#ifdef Included_pgpKeys_h
/*
 * egcs has some complaints about using kInvalidPGP...Ref types, so
 * I need to use the plain constant '0' to shut it up.
 */
#if PGP_COMPILER_GCC || PGP_COMPILER_HPUX || PGP_UNIX_DARWIN || ( PGP_COMPILER_SUN && PGP_COMPILER_SUN_VER == 5 )
	typedef StPGPRef<PGPKeySetRef, 0>	StPGPKeySetRef;
#else
	typedef StPGPRef<PGPKeySetRef, kInvalidPGPKeySetRef>	StPGPKeySetRef;
#endif /* PGP_COMPILER_HPUX */
	inline void StPGPKeySetRef::Dispose() { PGPFreeKeySet(mRef); }

#if PGP_COMPILER_GCC || PGP_COMPILER_HPUX || PGP_UNIX_DARWIN || ( PGP_COMPILER_SUN && PGP_COMPILER_SUN_VER == 5 )
	typedef StPGPRef<PGPKeyDBRef, 0>	StPGPKeyDBRef;
#else
	typedef StPGPRef<PGPKeyDBRef, kInvalidPGPKeyDBRef>	StPGPKeyDBRef;
#endif /* PGP_COMPILER_HPUX */
	inline void StPGPKeyDBRef::Dispose() { PGPFreeKeyDB(mRef); }

#if PGP_COMPILER_GCC || PGP_COMPILER_HPUX || PGP_UNIX_DARWIN || ( PGP_COMPILER_SUN && PGP_COMPILER_SUN_VER == 5 )
	typedef StPGPRef<PGPKeyListRef, 0>	StPGPKeyListRef;
#else
	typedef StPGPRef<PGPKeyListRef, kInvalidPGPKeyListRef>	StPGPKeyListRef;
#endif /* PGP_COMPILER_HPUX */
	inline void StPGPKeyListRef::Dispose() { PGPFreeKeyList(mRef); }

#if PGP_COMPILER_GCC || PGP_COMPILER_HPUX || PGP_UNIX_DARWIN || ( PGP_COMPILER_SUN && PGP_COMPILER_SUN_VER == 5 )
	typedef StPGPRef<PGPKeyIterRef, 0>	StPGPKeyIterRef;
#else
	typedef StPGPRef<PGPKeyIterRef, kInvalidPGPKeyIterRef>	StPGPKeyIterRef;
#endif /* PGP_COMPILER_HPUX */
	inline void StPGPKeyIterRef::Dispose() { PGPFreeKeyIter(mRef); }

#if PGP_COMPILER_GCC || PGP_COMPILER_HPUX || PGP_UNIX_DARWIN || ( PGP_COMPILER_SUN && PGP_COMPILER_SUN_VER == 5 )
	typedef StPGPRef<PGPFilterRef, 0>	StPGPFilterRef;
#else
	typedef StPGPRef<PGPFilterRef, kInvalidPGPFilterRef>	StPGPFilterRef;
#endif /* PGP_COMPILER_HPUX */
	inline void StPGPFilterRef::Dispose() { PGPFreeFilter(mRef); }
#endif

#ifdef Included_pgpHashing_h
#if PGP_COMPILER_GCC || PGP_COMPILER_HPUX || PGP_UNIX_DARWIN || ( PGP_COMPILER_SUN && PGP_COMPILER_SUN_VER == 5 )
	typedef StPGPRef<PGPHashContextRef, 0>	StPGPHashContextRef;
#else
	typedef StPGPRef<PGPHashContextRef, kInvalidPGPHashContextRef>	StPGPHashContextRef;
#endif /* PGP_COMPILER_HPUX */
	inline void StPGPHashContextRef::Dispose() { PGPFreeHashContext(mRef); }
#endif

#ifdef Included_PGPtls_h
#if PGP_COMPILER_GCC || PGP_COMPILER_HPUX || PGP_UNIX_DARWIN || ( PGP_COMPILER_SUN && PGP_COMPILER_SUN_VER == 5 )
	typedef StPGPRef<PGPtlsSessionRef, 0>	StPGPtlsSessionRef;
#else
	typedef StPGPRef<PGPtlsSessionRef, kInvalidPGPtlsSessionRef>	StPGPtlsSessionRef;
#endif /* PGP_COMPILER_HPUX */
	inline void StPGPtlsSessionRef::Dispose() { PGPFreeTLSSession(mRef); }
#endif

#ifdef Included_pgpMemoryMgr_h
	inline void StPGPRef<PGPByte *, 0>::Dispose() { PGPFreeData(mRef); }

	class StPGPDataRef	:	public StPGPRef<PGPByte *, 0> {
	public:
						StPGPDataRef() { }
						StPGPDataRef(PGPByte * inRef)
							{ Set(inRef); }

						operator char*() { return reinterpret_cast<char *>(mRef); }
		StPGPDataRef&	operator=(PGPByte * rhs) { mRef = rhs; return *this; }
#if PGP_COMPILER_SUN && PGP_COMPILER_SUN_VER == 4
		bool operator==(const int rhs) { return static_cast<int>(static_cast<void *>(mRef)) == rhs; }
#elif PGP_COMPILER_HPUX
		/* HACK ALERT: I'm not sure if this cast is OK, but it seems
		   to make aCC happy.  -elkins */
		bool operator==(const int rhs) { return (int) mRef == rhs; }
#endif
						operator void*() { return mRef; }
	};
	
#if PGP_COMPILER_GCC || PGP_COMPILER_HPUX || PGP_UNIX_DARWIN || ( PGP_COMPILER_SUN && PGP_COMPILER_SUN_VER == 5 )
	typedef StPGPRef<PGPMemoryMgrRef, 0>	StPGPMemoryMgrRef;
#else
	typedef StPGPRef<PGPMemoryMgrRef, kInvalidPGPMemoryMgrRef>	StPGPMemoryMgrRef;
#endif /* PGP_COMPILER_HPUX */
	inline void StPGPMemoryMgrRef::Dispose() { PGPFreeMemoryMgr(mRef); }

#endif /* Included_pgpMemoryMgr_h */

#ifdef Included_pgpSockets_h
#if PGP_COMPILER_GCC || PGP_COMPILER_HPUX || PGP_UNIX_DARWIN || ( PGP_COMPILER_SUN && PGP_COMPILER_SUN_VER == 5 )
	typedef StPGPRef<PGPSocketRef, 0>	StPGPSocketRef;
#else
	typedef StPGPRef<PGPSocketRef, kInvalidPGPSocketRef>	StPGPSocketRef;
#endif /* PGP_COMPILER_HPUX */
	inline void StPGPSocketRef::Dispose() { PGPCloseSocket(mRef); }
#endif

#ifdef Included_pgpIO_h
#if PGP_COMPILER_GCC || PGP_COMPILER_HPUX || PGP_UNIX_DARWIN || ( PGP_COMPILER_SUN && PGP_COMPILER_SUN_VER == 5 )
	typedef StPGPRef<PGPIORef, 0>	StPGPIORef;
#else
	typedef StPGPRef<PGPIORef, kInvalidPGPIORef>	StPGPIORef;
#endif /* PGP_COMPILER_HPUX */
	inline void StPGPIORef::Dispose() { PGPFreeIO(mRef); }
#endif



#ifdef Included_pgpKeyServer_h
#if PGP_COMPILER_GCC || PGP_COMPILER_HPUX || PGP_UNIX_DARWIN || ( PGP_COMPILER_SUN && PGP_COMPILER_SUN_VER == 5 )
	typedef StPGPRef<PGPKeyServerRef, 0>	StPGPKeyServerRef;
#else
	typedef StPGPRef<PGPKeyServerRef, kInvalidPGPKeyServerRef>	StPGPKeyServerRef;
#endif /* PGP_COMPILER_HPUX */
	inline void StPGPKeyServerRef::Dispose() { PGPFreeKeyServer(mRef); }
#endif


#ifdef Included_pgpUtilities_h
#if PGP_COMPILER_GCC || PGP_COMPILER_HPUX || PGP_UNIX_DARWIN || ( PGP_COMPILER_SUN && PGP_COMPILER_SUN_VER == 5 )
	typedef StPGPRef<PGPFileSpecRef, 0>	StPGPFileSpecRef;
#else
	typedef StPGPRef<PGPFileSpecRef, kInvalidPGPFileSpecRef>	StPGPFileSpecRef;
#endif /* PGP_COMPILER_HPUX */
	inline void StPGPFileSpecRef::Dispose() { PGPFreeFileSpec(mRef); }
#endif

#ifdef Included_pgpFileSpec_h
#if PGP_COMPILER_GCC || PGP_COMPILER_HPUX || PGP_UNIX_DARWIN || ( PGP_COMPILER_SUN && PGP_COMPILER_SUN_VER == 5 )
	typedef StPGPRef<PFLFileSpecRef, 0>	StPFLFileSpecRef;
#else
	typedef StPGPRef<PFLFileSpecRef, kInvalidPFLFileSpecRef>	StPFLFileSpecRef;
#endif
	inline void StPFLFileSpecRef::Dispose() { PFLFreeFileSpec(mRef); }
#endif


#ifdef Included_pflPrefs_h
	typedef StPGPRef<PGPPrefRef, kInvalidPGPPrefRef>	StPGPPrefRef;
	inline void StPGPPrefRef::Dispose() { PGPFreePrefs(mRef); }
	typedef StPGPRef<PGPPrefArray *, 0>	StPGPPrefArrayPtr;
	inline void StPGPPrefArrayPtr::Dispose() { PGPFreePrefArray(mRef); }
#endif


#ifdef Included_pgpKeyServerPrefs_h
	typedef StPGPRef<PGPKeyServerEntry *, 0>	StPGPKeyServerEntryPtr;
	inline void StPGPKeyServerEntryPtr::Dispose() { PGPFreeKeyServerList(mRef); }
#endif

#endif
